#!_PATH_TO_SHELL_

.  _PATH_TO_INSTALL_/bin/Definitions


export START=`GetValueFromQueryString "start"`
export STOP=`GetValueFromQueryString "stop"`
export PERIOD=`GetValueFromQueryString "period"`
export CT=`GetValueFromQueryString "ct"`
export OUT=`GetValueFromQueryString "out"`

export IMG_WIDTH=900
export IMG_HEIGHT=600
export MODEL=erlang.html
export TMPTBL="tmp_erlang_$$"

export DISPLAY=yes

if [ "$START" = "" ]
then
   DISPLAY=no
   START=`SqlQuery "select value from summaries where name = 'MinDate';"`
fi

if [ "$STOP" = "" ]
then
   DISPLAY=no
   STOP=`SqlQuery "select value from summaries where name = 'MaxDate';"`
fi

if [ "$DISPLAY" = "no" ]
then
  OUT=initial
fi

if [ "$PERIOD" == "" ]
then
   PERIOD=week
fi

if [ "$OUT" = "" ]
then
   OUT=initial
fi


if [ "$OUT" = "initial" -o "$OUT" = "table" -o "$OUT" = "graph" ]
then
   echo "Content-type: text/html"
   echo
   CutFile $MODEL "" "__INSERT_RESULT_HERE__"

   if [ "$OUT" = "table" ]
   then
      echo "<table border=1>"
      echo "<tr><td><b>Date</b></td><td><b>Nombre</b></td></tr>"
   fi
else
   echo "Content-type: image/jpeg"
   echo
fi

if [ "$OUT" = "table" -o "$OUT" = "jpeg" ]
then
   (
      (
	 echo "drop table if exists $TMPTBL;"
	 echo "create table $TMPTBL ( date timestamp, value int4);"
	 echo "copy $TMPTBL from STDIN DELIMITER AS '	';"
	 (
	    if [ "$CT" = "" ]
	    then
	       CTLISTCOND=""
	    else
	       CTLIST=`echo $CT | tr ' ' '\012' | sed "s/.*/'&',/g" | tr '\012' ' ' | sed 's/, *$//'`
	       CTLISTCOND="and calltype in ($CTLIST)"
	    fi

	    $PSQL -qtA '' -F '	' -U $PGUSER -d $PGDB << EOF

select date, inc from erlang_rawdata where
(
   (
      eventstart <= timestamp '$START' and    -- debut
      eventend   >= timestamp '$START'        -- debut
   )
   or
   (
      eventstart >= timestamp '$START' and    -- debut
      eventstart <= timestamp '$STOP'         -- fin
   )
)
and
date <= timestamp '$STOP'                     -- fin
$CTLISTCOND
order by date, inc desc;

EOF

	    #Add one 0 sample per observation period to ensure enough data

	    NOP=`SqlQuery "select 1 + ceil(extract ( epoch from (timestamp '$STOP' - timestamp '$START') ) / extract (epoch from interval '1 $PERIOD'));"`

	    echo "	" | expand -t $NOP | tr ' ' '\012' | grep -n "" | sed 's/\(.*\):.*/select timestamp '"'$START'"' + interval '"'"'\1 '"$PERIOD'"', 0;/g' | $PSQL -qtA '' -F '	' -U $PGUSER -d $PGDB

	 ) | awk -F '	' '
BEGIN { TOTAL=0 }
{
   TOTAL += $2
   printf( "%s\t%d\n", $1, TOTAL );
}' 
	 echo '\.'

	 echo "select date_trunc( '$PERIOD', date ) as point, max(value) from $TMPTBL where date >= timestamp '$START' and date <= timestamp '$STOP' group by point order by point;"

	 echo "drop table $TMPTBL;"
      ) | $PSQL -qtA '' -F '	' -U $PGUSER -d $PGDB  2> /dev/null
   ) | \
   if [ "$OUT" = "table" ]
   then
      cat | sed 's?\(.*\)	\(.*\)?<tr><td>\1</td><td align=right>\2</td></tr>?'
   else
      TMP_DATA=/tmp/tmpdata_$$
      TMP_IMG=/tmp/tmpimg_$$

      cat |cut -f2 > $TMP_DATA

      (
	 echo "set terminal jpeg transparent interlace size $IMG_WIDTH, $IMG_HEIGHT"
	 echo "set output \"$TMP_IMG\""
	 echo "set title \"Nombre de lignes\\n$START -> $STOP\""
	 echo "set xlabel \"\""
	 echo "set ylabel \"Nombre\""
	 echo "set nologscale x"
	 echo "set nologscale y"
	 echo "set key left"
	 echo "unset xtics"
	 echo "set style fill solid border -1"
	 echo "plot \"$TMP_DATA\" t \"Nombre\" with boxes"
	 echo "exit"
      ) | gnuplot 

      cat $TMP_IMG

      rm -f $TMP_DATA $TMP_IMG
   fi
fi

if [ "$OUT" = "table" ]
then
   echo "</table>";
fi

if [ "$OUT" = "graph" ]
then
   QS=`echo $QUERY_STRING |sed 's/=graph/=jpeg/g'`
   echo "<img src=$SCRIPT_NAME?$QS width=$IMG_WIDTH height=$IMG_HEIGHT>"
fi

if [ "$OUT" = "initial" -o "$OUT" = "table" -o "$OUT" = "graph" ]
then
   CutFile $MODEL "__INSERT_RESULT_HERE__" "__INSERT_CALLTYPES_HERE__" | sed "s/__INSERT_START_HERE__/$START/g" | sed "s/__INSERT_STOP_HERE__/$STOP/g" | sed "s/=$PERIOD/& selected/g"

   SqlQuery "select * from calltypes union select value, 'Unkown' from summaries where name = 'CallType' and value not in ( select calltype from calltypes);" |while read id desc
   do
      DIS=`SqlQuery "select value from summaries where name = 'CallType' and value = '$id';"`

      if [ "$DIS" = "" ]
      then
         STATUS=disabled
	 CHECK=""
      else
         STATUS=""
         if [ "$CT" = "" ]
         then
            CHECK=checked
         else
	    CTO=`echo "$CT" | grep "^$id$"`
	    if [ "$CTO" = "" ]
	    then
               CHECK=""
	    else
	       CHECK=checked
	    fi
         fi
      fi
      
      echo "<input type=checkbox name=ct value=$id $STATUS $CHECK>$desc ($id)<br>"
   done


   if [ "$DISPLAY" = "no" ]
   then
      CutFile $MODEL "__INSERT_CALLTYPES_HERE__" "" | sed "s/=jpeg/& selected/g"
   else
      CutFile $MODEL "__INSERT_CALLTYPES_HERE__" "" | sed "s/=$OUT/& selected/g"
   fi
fi

exit 0
