#!_PATH_TO_SHELL_

.  _PATH_TO_INSTALL_/bin/Definitions


export START=`GetValueFromQueryString "start"`
export STOP=`GetValueFromQueryString "stop"`
export NTOP=`GetValueFromQueryString "ntop"`
export CT=`GetValueFromQueryString "ct"`
export OUT=`GetValueFromQueryString "out"`

export IMG_WIDTH=900
export IMG_HEIGHT=600
export MODEL=topconso.html

DISPLAY=yes

if [ "$START" = "" ]
then
   DISPLAY=no
   START=`SqlQuery "select value from summaries where name = 'MinDate';"`
fi

if [ "$STOP" = "" ]
then
   DISPLAY=no
   STOP=`SqlQuery "select value from summaries where name = 'MaxDate';"`
fi

if [ "$DISPLAY" = "no" ]
then
  OUT=initial
fi

if [ "$NTOP" == "" ]
then
   NTOP=30
fi

if [ "$OUT" = "" ]
then
   OUT=initial
fi


if [ "$OUT" = "initial" -o "$OUT" = "table" -o "$OUT" = "graph" ]
then
   echo "Content-type: text/html"
   echo
   CutFile $MODEL "" "__INSERT_RESULT_HERE__"

   if [ "$OUT" = "table" ]
   then
      echo "<table border=1>"
      echo "<tr><td><b>Poste</b></td><td><b>Personne</b></td><td><b>Dure</b></td></tr>"
   fi
else
   echo "Content-type: image/jpeg"
   echo
fi

if [ "$OUT" = "table" -o "$OUT" = "jpeg" ]
then
   if [ "$CT" = "" ]
   then
      CTLISTCOND=""
   else
      CTLIST=`echo $CT | tr ' ' '\012' | sed "s/.*/'&',/g" | tr '\012' ' ' | sed 's/, *$//'`
      CTLISTCOND="and calltype in ($CTLIST)"
   fi

   if [ "$OUT" = "table" ]
   then
      SqlQuery "select ChargedNumber, ChargedUserName, sum(Duration) * interval  '1 second' as Temps from taxdata where enddatetime >= timestamp '$START' and enddatetime <=  timestamp '$STOP' $CTLISTCOND group by ChargedNumber, ChargedUserName order by Temps desc limit $NTOP;" | sed 's?\(.*\)	\(.*\)	\(.*\)?<tr><td>\1</td><td>\2</td><td align=right>\3</td></tr>?'
   else
      TMP_DATA_FULL=/tmp/tmpdatafull_$$
      TMP_DATA=/tmp/tmpdata_$$
      TMP_IMG=/tmp/tmpimg_$$

      (
	 echo "		0"
         SqlQuery "select ChargedNumber, ChargedUserName, sum(Duration) as Temps from taxdata where enddatetime >= timestamp '$START' and enddatetime <= timestamp '$STOP' $CTLISTCOND group by ChargedNumber, ChargedUserName order by Temps desc limit $NTOP;" 
	 echo "		0"
      ) > $TMP_DATA_FULL

      cat  $TMP_DATA_FULL | cut -f3 > $TMP_DATA
      LABELS=`cat $TMP_DATA_FULL | cut -f1-2 | tail +2 | sed 's/$/                     /g' | cut -c 1-20 | sed 's/\(.*\)	\(.*\)/ \2 (\1)/g' | grep -n "" |sed 's/:/	/g' | sed 's/\(.*\)	\(.*\)/"\2" \1,/g' | tr '\n' ' ' | sed 's/,[^,]*, *$//'`

echo LABELS=$LABELS >&2
      (
	 echo "set terminal jpeg transparent interlace size $IMG_WIDTH, $IMG_HEIGHT"
	 echo "set output \"$TMP_IMG\""
	 echo "set title \"Top $NTOP des consommateurs\\n$START -> $STOP\""
	 echo "set xlabel \"\""
	 echo "set ylabel \"Dure (s)\""
	 echo "set nologscale x"
	 echo "set nologscale y"
	 echo "set key left"
	 echo "set xtics border nomirror rotate ($LABELS)"
	 echo "set style fill solid border -1"
	 echo "plot \"$TMP_DATA\" t \"Nombre\" with boxes"
	 echo "exit"
      ) | gnuplot 

      cat $TMP_IMG

      rm -f $TMP_DATA $TMP_IMG $TMP_DATA_FULL
   fi
fi

if [ "$OUT" = "table" ]
then
   echo "</table>";
fi

if [ "$OUT" = "graph" ]
then
   QS=`echo $QUERY_STRING |sed 's/=graph/=jpeg/g'`
   echo "<img src=$SCRIPT_NAME?$QS width=$IMG_WIDTH height=$IMG_HEIGHT>"
fi

if [ "$OUT" = "initial" -o "$OUT" = "table" -o "$OUT" = "graph" ]
then
   CutFile $MODEL "__INSERT_RESULT_HERE__" "__INSERT_CALLTYPES_HERE__" | sed "s/__INSERT_START_HERE__/$START/g" | sed "s/__INSERT_STOP_HERE__/$STOP/g" | sed "s/__INSERT_NTOP_HERE__/$NTOP/g"

   SqlQuery "select * from calltypes union select value, 'Unkown' from summaries where name = 'CallType' and value not in ( select calltype from calltypes);" |while read id desc
   do
      DIS=`SqlQuery "select value from summaries where name = 'CallType' and value = '$id';"`

      if [ "$DIS" = "" ]
      then
         STATUS=disabled
	 CHECK=""
      else
         STATUS=""
         if [ "$CT" = "" ]
         then
            CHECK=checked
         else
	    CTO=`echo "$CT" | grep "^$id$"`
	    if [ "$CTO" = "" ]
	    then
               CHECK=""
	    else
	       CHECK=checked
	    fi
         fi
      fi
      
      echo "<input type=checkbox name=ct value=$id $STATUS $CHECK>$desc ($id)<br>"
   done


   if [ "$DISPLAY" = "no" ]
   then
      CutFile $MODEL "__INSERT_CALLTYPES_HERE__" "" | sed "s/=jpeg/& selected/g"
   else
      CutFile $MODEL "__INSERT_CALLTYPES_HERE__" "" | sed "s/=$OUT/& selected/g"
   fi
fi

exit 0
