#!_PATH_TO_SHELL_

.  _PATH_TO_INSTALL_/bin/Definitions


export START=`GetValueFromQueryString "start"`
export STOP=`GetValueFromQueryString "stop"`
export CT=`GetValueFromQueryString "ct"`

export MODEL=geographic.html

DISPLAY=yes

if [ "$START" = "" ]
then
   DISPLAY=no
   START=`SqlQuery "select value from summaries where name = 'MinDate';"`
fi

if [ "$STOP" = "" ]
then
   DISPLAY=no
   STOP=`SqlQuery "select value from summaries where name = 'MaxDate';"`
fi

echo "Content-type: text/html"
echo
CutFile $MODEL "" "__INSERT_RESULT_HERE__"

function Recurse()
{
   (
      START="$1"
      STOP="$2"
      CTLISTCOND="$3"
      LEVEL="$4"
      SUBZONE="$5"

      SqlQuery "select count(*), sum(duration) * interval '1 second', zone, subzone, min(final) from geozones g, taxdata t where g.taxdataid = t.id and g.level = $LEVEL and zone like '$SUBZONE[%' $CTLISTCOND group by zone, subzone order by subzone" | while read line
      do
         nbr=`echo "$line" | cut -d'	' -f1`
         duration=`echo "$line" | cut -d'	' -f2`
         zone=`echo "$line" | cut -d'	' -f3`
         subzone=`echo "$line" | cut -d'	' -f4`
         final=`echo "$line" | cut -d'	' -f5`

         echo '<tr>'
         N=0; while [ "$N" -lt $LEVEL ]; do echo "<td>&nbsp;</td>"; N=`expr $N + 1`; done

         echo "<td align=right>$nbr</td><td colspan=99>$subzone ($duration)</td>"
         echo '</tr>'
	 L=`expr $LEVEL + 1`

         if [ "$final" = "0" ]
         then
            Recurse "$START" "$STOP" "$CTLISTCOND" $L "$zone"
         fi
      done

      if [ "$LEVEL" -gt 0 ]
      then
	 line=""

         SqlQuery "select count(*), sum(duration) * interval '1 second', zone, subzone from geozones g, taxdata t where g.taxdataid = t.id and g.level = $LEVEL - 1 and zone = '$SUBZONE' and g.final = 1 $CTLISTCOND group by zone, subzone order by subzone"  | while read line
         do
            nbr=`echo "$line" | cut -d'	' -f1`
            duration=`echo "$line" | cut -d'	' -f2`
            zone=`echo "$line" | cut -d'	' -f3`
            subzone=`echo "$line" | cut -d'	' -f4`

            echo '<tr>'
            N=0; while [ "$N" -lt $LEVEL ]; do echo "<td>&nbsp;</td>"; N=`expr $N + 1`; done
   
            echo "<td align=right>$nbr</td><td colspan=99>Sans dtail ($duration)</td>"
            echo '</tr>'
	 done
      fi
   )
}

if [ "$DISPLAY" = "yes" ]
then
   echo "<table>"

   if [ "$CT" = "" ]
   then
      CTLISTCOND=""
   else
      CTLIST=`echo $CT | tr ' ' '\012' | sed "s/.*/'&',/g" | tr '\012' ' ' | sed 's/, *$//'`
      CTLISTCOND="and calltype in ($CTLIST)"
   fi

   Recurse "$START" "$STOP" "$CTLISTCOND" 0 ""

   echo "</table>"
fi

CutFile $MODEL "__INSERT_RESULT_HERE__" "__INSERT_CALLTYPES_HERE__" | sed "s/__INSERT_START_HERE__/$START/g" | sed "s/__INSERT_STOP_HERE__/$STOP/g" | sed "s/__INSERT_NTOP_HERE__/$NTOP/g"

SqlQuery "select * from calltypes union select value, 'Unkown' from summaries where name = 'CallType' and value not in ( select calltype from calltypes);" |while read id desc
do
   DIS=`SqlQuery "select value from summaries where name = 'CallType' and value = '$id';"`

   if [ "$DIS" = "" ]
   then
      STATUS=disabled
      CHECK=""
   else
      STATUS=""
      if [ "$CT" = "" ]
      then
	 CHECK=checked
      else
	 CTO=`echo "$CT" | grep "^$id$"`
	 if [ "$CTO" = "" ]
	 then
	    CHECK=""
	 else
	    CHECK=checked
	 fi
      fi
   fi
      
   echo "<input type=checkbox name=ct value=$id $STATUS $CHECK>$desc ($id)<br>"
done

CutFile $MODEL "__INSERT_CALLTYPES_HERE__" ""

exit 0
